/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.FabricAdapter;
import com.epherical.croptopia.SetupCommand;
import com.epherical.croptopia.config.CroptopiaConfig;
import com.epherical.croptopia.config.IdentifierSerializer;
import com.epherical.croptopia.config.TreeConfiguration;
import com.epherical.croptopia.dependencies.Patchouli;
import com.epherical.croptopia.generator.BiomeModifiers;
import com.epherical.croptopia.items.CropLootTableModifier;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.mixin.AxeAccess;
import com.epherical.croptopia.mixin.ChickenAccess;
import com.epherical.croptopia.mixin.FarmerWorkTaskAccessor;
import com.epherical.croptopia.mixin.ParrotAccess;
import com.epherical.croptopia.mixin.VillagerAccess;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.registry.Composter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class Croptopia
implements ModInitializer {
    private final boolean devEnvironment = Boolean.getBoolean("croptopia.dev");
    public CroptopiaConfig config;
    public static final class_1761 CROPTOPIA_ITEM_GROUP = FabricItemGroupBuilder.create((class_2960)new class_2960("croptopia", "croptopia")).icon(() -> new class_1799((class_1935)Content.COFFEE)).build();
    public static Patchouli patchouli;
    private static final String TECH_REBORN_MOD_ID = "techreborn";

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(TECH_REBORN_MOD_ID).map(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("croptopia", "treborn"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED)).filter(success -> success == false);
        CroptopiaMod mod = new CroptopiaMod(new FabricAdapter());
        Content.registerBlocks((id, object) -> (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)id, (Object)object));
        Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)CroptopiaMod.createIdentifier("guide"), (Object)Content.GUIDE);
        Content.registerItems((id, object) -> (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)id, (Object)object));
        patchouli = new Patchouli();
        Composter.init();
        this.config = new CroptopiaConfig(this.devEnvironment, "croptopia.conf");
        this.config.addSerializer(TreeConfiguration.class, TreeConfiguration.Serializer.INSTANCE);
        this.config.addSerializer(class_2960.class, IdentifierSerializer.INSTANCE);
        this.config.loadConfig();
        BiomeModifiers.init(this);
        CropLootTableModifier.init();
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> SetupCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        this.modifyVillagerFoodItems();
        this.modifyVillagerGatherables();
        this.modifyAxeBlockStripping();
        this.modifyChickenBreeds();
        this.modifyParrotBreeds();
        this.modifyVillagerFarmerTaskCompostables();
    }

    public static class_2960 createIdentifier(String name) {
        return new class_2960("croptopia", name);
    }

    private void modifyVillagerFoodItems() {
        ImmutableMap.Builder villagerFoodItems = new ImmutableMap.Builder().putAll(VillagerAccess.getItemFoodValues());
        Content.createCropStream().filter(item -> item.method_19264() != null).forEach(item -> villagerFoodItems.put(item, (Object)item.method_19264().method_19230()));
        VillagerAccess.setItemFoodValues((Map<class_1792, Integer>)villagerFoodItems.build());
    }

    private void modifyVillagerGatherables() {
        ImmutableSet.Builder villagerGatherables = new ImmutableSet.Builder().addAll(VillagerAccess.getGatherableItems());
        CroptopiaMod.seeds.forEach(arg_0 -> ((ImmutableSet.Builder)villagerGatherables).add(arg_0));
        Content.createCropStream().forEach(arg_0 -> ((ImmutableSet.Builder)villagerGatherables).add(arg_0));
        VillagerAccess.setGatherableItems((Set<class_1792>)villagerGatherables.build());
    }

    private void modifyAxeBlockStripping() {
        Map<class_2248, class_2248> immutableBlocks = AxeAccess.getStrippables();
        ImmutableMap.Builder axeMap = new ImmutableMap.Builder().putAll(immutableBlocks);
        for (Tree crop : Tree.copy()) {
            axeMap.put((Object)crop.getLog(), (Object)crop.getStrippedLog());
            axeMap.put((Object)crop.getWood(), (Object)crop.getStrippedWood());
        }
        AxeAccess.setStrippables((Map<class_2248, class_2248>)axeMap.build());
    }

    private void modifyChickenBreeds() {
        IntList stacks = ChickenAccess.getFoodItems().method_8100();
        ArrayList<Object> baseItems = new ArrayList<Object>();
        for (Integer stack : stacks) {
            baseItems.add(class_1792.method_7875((int)stack));
        }
        baseItems.addAll(CroptopiaMod.seeds);
        ChickenAccess.setFoodItems(class_1856.method_8091((class_1935[])((class_1935[])baseItems.toArray(new class_1792[0]))));
    }

    private void modifyParrotBreeds() {
        Set<class_1792> baseItems = ParrotAccess.getTamingIngredients();
        HashSet newItems = Sets.newHashSet(baseItems);
        newItems.addAll(CroptopiaMod.seeds);
        ParrotAccess.setTamingIngredients(newItems);
    }

    private void modifyVillagerFarmerTaskCompostables() {
        List<class_1792> baseItems = FarmerWorkTaskAccessor.getCompostables();
        ArrayList newItems = Lists.newArrayList(baseItems);
        newItems.addAll(CroptopiaMod.seeds);
        FarmerWorkTaskAccessor.setCompostables(newItems);
    }
}

